/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.bwt.JCSerializable;
import jclass.chart.ChartDataView;
import jclass.chart.DerivedInt;
import jclass.chart.JCAxis;
import jclass.chart.JCChartStyle;
import jclass.chart.MinMax;

public class ChartDataViewSeries
implements JCSerializable {
    ChartDataView parent;
    private double[] xvalues;
    private double[] yvalues;
    int firstPoint;
    DerivedInt lastPoint = new DerivedInt(0, true);
    String name;
    int drawingOrder = -1;
    boolean isShowing = true;
    boolean isShowingInLegend = true;
    boolean isIncluded = true;
    String label;
    static int dataViewSeriesNum;

    void init(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
        } else {
            this.firstPoint = 0;
            this.lastPoint.value = this.maxIndex();
            this.lastPoint.isDefault = true;
        }
        this.name = "DataViewSeries #" + ++dataViewSeriesNum;
    }

    public ChartDataViewSeries() {
        this.parent = null;
        this.xvalues = null;
        this.yvalues = null;
    }

    ChartDataViewSeries(double[] dArray, double[] dArray2, ChartDataView chartDataView) {
        this.parent = chartDataView;
        this.xvalues = dArray;
        this.yvalues = dArray2;
        if (dArray2 == null) {
            this.firstPoint = Integer.MAX_VALUE;
            this.lastPoint.value = Integer.MAX_VALUE;
            this.lastPoint.isDefault = true;
            return;
        }
        this.firstPoint = 0;
        this.lastPoint.value = this.maxIndex();
        this.lastPoint.isDefault = true;
    }

    public void editPoint(int n, double d) {
        if (this.parent.editPoint(this, n, d)) {
            this.yvalues[n] = d;
            this.parent.setChanged(true);
        }
    }

    public int getFirstPoint() {
        return this.firstPoint;
    }

    public synchronized void setFirstPoint(int n) {
        if (n < 0 || n > this.maxIndex()) {
            throw new IllegalArgumentException("FirstPoint value does not address a point in the data series");
        }
        if (this.firstPoint == n) {
            return;
        }
        this.firstPoint = n;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public int getLastPoint() {
        if (this.lastPoint.isDefault) {
            return Math.min(this.getY().length, this.getX().length) - 1;
        }
        return this.lastPoint.value;
    }

    public boolean getLastPointIsDefault() {
        return this.lastPoint.isDefault;
    }

    public synchronized void setLastPoint(int n) {
        if (n < 0 || n > this.maxIndex()) {
            throw new IllegalArgumentException("LastPoint value does not address a point in the data series");
        }
        if (this.lastPoint.value == n) {
            return;
        }
        this.lastPoint.value = n;
        this.lastPoint.isDefault = false;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public synchronized void setLastPointIsDefault(boolean bl) {
        this.lastPoint.isDefault = bl;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        if (this.name == string) {
            return;
        }
        this.name = string;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public JCChartStyle getStyle() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getSeriesIndex(this);
        if (n < 0) {
            return null;
        }
        return this.parent.getChartStyle(n);
    }

    public synchronized void setStyle(JCChartStyle jCChartStyle) {
        if (this.parent == null) {
            return;
        }
        int n = this.parent.getSeriesIndex(this);
        this.parent.setChartStyle(n, jCChartStyle);
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public synchronized void setDrawingOrder(int n) {
        if (this.drawingOrder == n) {
            return;
        }
        this.drawingOrder = n;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public synchronized void setIsShowing(boolean bl) {
        if (bl == this.isShowing) {
            return;
        }
        this.isShowing = bl;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public boolean getIsShowingInLegend() {
        return this.isShowingInLegend;
    }

    public synchronized void setIsShowingInLegend(boolean bl) {
        if (bl == this.isShowingInLegend) {
            return;
        }
        this.isShowingInLegend = bl;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public boolean getIsIncluded() {
        return this.isIncluded;
    }

    public synchronized void setIsIncluded(boolean bl) {
        if (bl == this.isIncluded) {
            return;
        }
        this.isIncluded = bl;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public synchronized void setLabel(String string) {
        if (string == this.label) {
            return;
        }
        this.label = string;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = new String("Series " + (this.drawingOrder + 1));
        }
        return this.label;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            return "Unnamed DataViewSeries";
        }
        return string;
    }

    int maxXIndex() {
        int n;
        int n2 = this.parent == null ? 0 : (n = this.parent.getX() == null ? 0 : this.parent.getX().length);
        if (this.xvalues == null) {
            return n;
        }
        return this.xvalues.length;
    }

    int maxYIndex() {
        if (this.yvalues == null) {
            return 0;
        }
        return this.yvalues.length;
    }

    int maxIndex() {
        return Math.max(0, Math.min(this.maxXIndex(), this.maxYIndex()) - 1);
    }

    void getXMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        minMax.setMinMax(this.xvalues == null ? this.parent.getX() : this.xvalues, this.parent.holeValue);
    }

    void calcStep(JCAxis jCAxis) {
        double[] dArray;
        double[] dArray2 = dArray = this.xvalues == null ? this.parent.getX() : this.xvalues;
        if (dArray == null || dArray.length == 0) {
            return;
        }
        int n = 1;
        while (n < dArray.length) {
            double d = dArray[n] - dArray[n - 1];
            if (d < 0.0) {
                d = -d;
            }
            if (d < jCAxis.step && d != 0.0) {
                jCAxis.step = d;
            }
            ++n;
        }
        if (jCAxis.step == Double.MAX_VALUE) {
            jCAxis.step = 1.0;
        }
    }

    void getYMinMax(MinMax minMax) {
        if (minMax == null) {
            return;
        }
        minMax.setMinMax(this.yvalues, this.parent.holeValue);
    }

    public double getX(int n) {
        if (this.xvalues == null) {
            return this.parent.getX()[n];
        }
        return this.xvalues[n];
    }

    public double getY(int n) {
        return this.yvalues[n];
    }

    double[] getX() {
        if (this.xvalues == null) {
            return this.parent.getX();
        }
        return this.xvalues;
    }

    double[] getY() {
        return this.yvalues;
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    void setY(double[] dArray) {
        this.yvalues = dArray;
    }

    public int getX(double d) {
        return this.getPoint(d, this.getX());
    }

    public int getY(double d) {
        return this.getPoint(d, this.yvalues);
    }

    int getPoint(double d, double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double d3 = Math.abs(dArray[n2] - d);
            if (d3 < d2) {
                d2 = d3;
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

